

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************


**********************************************************************************
**********************************************************************************
*** Table A.7: Share of religious laws and historic high gods across countries, Spatially correlated Conley standard errors
**********************************************************************************
use country_final, clear

***
* To reproduce robust standard errors
* column 1
reg rslegis god, r
* column 2
reghdfe rslegis god, a(continent) vce(r)
* column 3
reghdfe rslegis god year_ethno, a(continent) vce(r)
* column 4
reghdfe rslegis god abslat_jb, a(continent) vce(r)
* column 5
reghdfe rslegis god agr_suit_mean, a(continent) vce(r)
* column 6
reghdfe rslegis god comm00, a(continent) vce(r)
* column 7
reghdfe rslegis god lnrgdp, a(continent) vce(r)
* column 8
reghdfe rslegis god muslimdum, a(continent) vce(r)


***
* To produce standard errors robust to Spatial Correlation within 300kms
reg rslegis god, r
keep if e(sample)
* column 1
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(300) bartlett
* column 2
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)
* column 3
acreg rslegis god year_ethno, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)
* column 4
acreg rslegis god abslat_jb, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)
* column 5
acreg rslegis god agr_suit_mean, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)
* column 6
acreg rslegis god comm00, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)
* column 7
acreg rslegis god lnrgdp, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)
* column 8
acreg rslegis god muslimdum, spatial latitude(lat) longitude(lon) dist(300) bartlett pfe1(cont)


***
* To produce standard errors robust to Spatial Correlation within 500kms
reg rslegis god, r
keep if e(sample)
* column 1
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(500) bartlett
* column 2
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)
* column 3
acreg rslegis god year_ethno, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)
* column 4
acreg rslegis god abslat_jb, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)
* column 5
acreg rslegis god agr_suit_mean, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)
* column 6
acreg rslegis god comm00, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)
* column 7
acreg rslegis god lnrgdp, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)
* column 8
acreg rslegis god muslimdum, spatial latitude(lat) longitude(lon) dist(500) bartlett pfe1(cont)


***
* To produce standard errors robust to Spatial Correlation within 1000kms
reg rslegis god, r
keep if e(sample)
* column 1
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(1000) bartlett
* column 2
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)
* column 3
acreg rslegis god year_ethno, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)
* column 4
acreg rslegis god abslat_jb, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)
* column 5
acreg rslegis god agr_suit_mean, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)
* column 6
acreg rslegis god comm00, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)
* column 7
acreg rslegis god lnrgdp, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)
* column 8
acreg rslegis god muslimdum, spatial latitude(lat) longitude(lon) dist(1000) bartlett pfe1(cont)


***
* To produce standard errors robust to Spatial Correlation within 2000kms
reg rslegis god, r
keep if e(sample)
* column 1
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(2000) bartlett
* column 2
acreg rslegis god, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)
* column 3
acreg rslegis god year_ethno, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)
* column 4
acreg rslegis god abslat_jb, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)
* column 5
acreg rslegis god agr_suit_mean, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)
* column 6
acreg rslegis god comm00, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)
* column 7
acreg rslegis god lnrgdp, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)
* column 8
acreg rslegis god muslimdum, spatial latitude(lat) longitude(lon) dist(2000) bartlett pfe1(cont)

********************************************************************************************************************************************************************
